% ex7_52kf.m
% Estimation of heat equation 
% by Kalman filter 
% section 7.5.2
clear

dt=0.1;
dt2=sqrt(dt);
T=100;
N=T/dt;
NN=0:N;
drho=1;
alpha=2.5;
f1=1/1000;
f2=1/1000;
lam=alpha*dt/drho^2;
xb0=30;
xbL=30;
xt0=30;
n=99;  % j=1:n
j1=33;
j2=67;
p=9;
x0=zeros(n,1);
for j=1:n
    x0(j,1)=xt0;
end    
dd=zeros(n,1);
dd(1,1)=lam*xb0;
dd(n,1)=lam*xbL;
b1=5; b2=5;
u=zeros(2,N+1);
for k=1:N+1
u(1,k)=b1*sin(2*pi*f1*k)+b1;
u(2,k)=b2*sin(2*pi*f2*k)+b2;
end
B1=zeros(n,1);
B2=zeros(n,1);
B1(j1,1)=dt;
B2(j2,1)=dt;
for i=1:n-1
    F(i,i)=1-2*lam;
    F(i,i+1)= lam;
    F(i+1,i)=lam;
end
F(n,n)=1-2*lam;
Q=0.001*eye(n,n);
R=0.1*eye(p,p);
jj=40;
H=zeros(p,n);
y=zeros(p,N+1);
for i=1:p
    H(i,10*i)=1;
end    

MM=30;  % Number of Monte Calro runs
tic
for mc=1:MM
mc
% data generation 
w=sqrt(Q)*randn(n,N+1);   % system noise
v=sqrt(R)*randn(p,N+1);   % observation noise
%
x=zeros(n,N+1);
x(:,1)=x0;
for k=1:N
x(:,k+1)=F*x(:,k) + dd + B1*u(1,k)+B2*u(2,k)+dt2*w(:,k);
y(:,k)= H*x(:,k) + v(:,k);
end
y(:,N+1)=H*x(:,N+1)+v(:,N+1);
% Kalman filter
xep=zeros(n,2);       % temp prediction
Pep=zeros(n,n,2);     % temp prediction P_{t/t-1}
xef=zeros(n,N+1);     % filtering  x_{t/t}
Pef=zeros(n,n,N+1);   % variance of filtering P_{t/t}
Pep(:,:,1)=1*eye(n,n);  % initial covariance
xep(:,1)=xt0*ones(n,1);   
xep(:,1)=xep(:,1)+ sqrt(1)*randn(n,1); % initial estimate
for k=1:N
% filtering    
K=Pep(:,:,1)*H'*inv(H*Pep(:,:,1)*H' + R);   
Pef(:,:,k)=Pep(:,:,1)- K*H*Pep(:,:,1);  
xef(:,k)=xep(:,1) + K*(y(:,k)-H*xep(:,1));    
% prediction
Pep(:,:,2)=F*Pef(:,:,k)*F' + dt*Q;   
xep(:,2)=F*xef(:,k) + dd + B1*u(1,k)+B2*u(2,k);        
xep(:,1)=xep(:,2);
Pep(:,:,1)=Pep(:,:,2);
end
K=Pep(:,:,1)*H'*inv(H*Pep(:,:,1)*H' + R);  
Pef(:,:,N+1)=Pep(:,:,1)-K*H*Pep(:,:,1);  
xef(:,N+1)=xep(:,1) + K*(y(:,N+1)-H*xep(:,1));
% end of k
T2=toc

% variances of estimation error
for k=1:N+1
Et(mc,k)=(xef(jj,k)-x(jj,k))^2; 
Pt(k)=Pef(jj,jj,k);
end
end % end of mc
Ett=mean(Et,1);


Ymax=1e-1;
Ymin=1e-4;
J=NN;
figure(1)
plot(J,y(1,:),J,y(2,:),J,y(3,:),J,y(4,:),J,y(5,:))
legend('y_1','y_2','y_3','y_4','y_5','Location','NorthWest')
xlabel('Number of steps k')
title('Fig. 7.6a: Output observations')
axis([0 1000 25 50])
grid

figure(2)
semilogy(J,Ett,'b-',J,Pt,'r-','LineWidth',1.5)
axis([0 1000 Ymin Ymax])
legend('Sample value E_k','True value P_{k|k}')
xlabel('Number of steps k')
ylabel('E_k, P_{k|k}')
title('Fig. 7.6b: Variances of estimation errors')
grid





